﻿using System;
using System.Collections.Generic;
using System.Threading;
using System.Linq;
using System.Text;
using Microsoft.ServiceHosting.ServiceRuntime;
using System.Configuration;
using System.ServiceModel;
using System.ServiceModel.Description;
using Microsoft.ServiceBus;
using Microsoft.ServiceBus.Description;
using ProAzureDemResContract;
using AzureSample;


namespace DemResWorkerRole
{
 public class WorkerRole : RoleEntryPoint
 {
  private ServiceHost host;
  private ServiceBusLogger logger;

  public override void Start()
  {
   try
   {
    string userName = GetStringConfigurationValue("UserName");
    string password = GetStringConfigurationValue("Password");
    string demResEndPoint = GetStringConfigurationValue("DemResEndpoint");
    string logEndPoint = GetStringConfigurationValue("LogEndpoint");

    ServiceBusLogger logger = new ServiceBusLogger(logEndPoint, userName, password);

    logger.Channel.WriteToLog(DateTime.UtcNow, "Worker Role", "Role Started");

    Uri uri = new Uri(demResEndPoint);
    TransportClientEndpointBehavior userNamePasswordServiceBusCredential = new TransportClientEndpointBehavior();
    userNamePasswordServiceBusCredential.CredentialType = TransportClientCredentialType.UserNamePassword;
    userNamePasswordServiceBusCredential.Credentials.UserName.UserName = userName;
    userNamePasswordServiceBusCredential.Credentials.UserName.Password = password;
    host = new ServiceHost(typeof(DemResService), uri);
    logger.Channel.WriteToLog(DateTime.UtcNow, "Worker Role", "Service Host created");
    ContractDescription contractDescription = ContractDescription.GetContract(typeof(IDemResOperations), typeof(DemResService));
    ServiceEndpoint serviceEndPoint = new ServiceEndpoint(contractDescription);

    serviceEndPoint.Address = new EndpointAddress(uri);
    logger.Channel.WriteToLog(DateTime.UtcNow, "Worker Role", "Address created");

    serviceEndPoint.Binding = new NetTcpRelayBinding();

    logger.Channel.WriteToLog(DateTime.UtcNow, "Worker Role", "Binding created");

    //Set the DiscoveryType to Public and Publish this in the Service Registry
    ServiceRegistrySettings serviceRegistrySettings = new ServiceRegistrySettings();
    serviceRegistrySettings.DiscoveryMode = DiscoveryType.Public;
    serviceRegistrySettings.DisplayName = "Demand-Response Service";


    serviceEndPoint.Behaviors.Add(userNamePasswordServiceBusCredential);
    serviceEndPoint.Behaviors.Add(serviceRegistrySettings);

    logger.Channel.WriteToLog(DateTime.UtcNow, "Worker Role", "Added behaviors");


    host.Description.Endpoints.Add(serviceEndPoint);
    host.Open();
    logger.Channel.WriteToLog(DateTime.UtcNow, "Worker Role", "Host opened");

    while (true)
    {

     Thread.Sleep(10000);
     logger.Channel.WriteToLog(DateTime.UtcNow, "Worker Role", "Working…");


    }
   }
   catch (Exception ex)
   {

    RoleManager.WriteToLog("Error", "Error starting role " + ex.Message);
    RoleManager.WriteToLog("Error", "Stack Trace " + ex.StackTrace);
   }
  }



  public override void Stop()
  {

   host.Close();

   base.Stop();

  }
  public override RoleStatus GetHealthStatus()
  {
   // This is a sample worker implementation. Replace with your logic.
   return RoleStatus.Healthy;
  }

  public string GetStringConfigurationValue(string configName)
  {

   try
   {
    return RoleManager.GetConfigurationSetting(configName);


   }
   catch (Exception ex)
   {
    logger.Channel.WriteToLog(DateTime.UtcNow,"Worker Role", ex.Message);

    throw ex;

   }


  }
 }
}
